<?php

namespace backend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\User;

/**
 * UserSearch represents the model behind the search form about `common\models\User`.
 */
class UserForm extends User
{
    public $password;
    public $confirmPassword;
    
    /**
     * @return array the validation rules.
     */
    public function rules()
    {
        return [
            // username and password are both required
            [['password', 'confirmPassword'], 'string'],
            [['status'], 'integer'],
            [['email', 'password_hash'], 'required'],
            [['email'], 'unique', 'message' => 'Please input another e-mail'],
            ['confirmPassword',  function ($attribute, $params, $validator) {
                if ($this->password != $this->confirmPassword) {
                    $this->addError($attribute, 'Password wasn\'t equals');
                }
            }],
        ];
    }

    public function attributeLabels()
    {
        $labels = parent::attributeLabels(); // TODO: Change the autogenerated stub
        $labels['password'] = Yii::t('app', 'Password');
        $labels['confirmPassword'] = Yii::t('app', 'Confirm Password');
        return $labels;
    }

    public function updateUser()
    {
        if ($this->password == $this->confirmPassword && !empty($this->password)) {
            $this->setPassword($this->password);
        }
        
        return $this->save();
    }

}


